/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.log;

import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.microemu.app.util.IOUtils;
import org.microemu.log.LoggerAppender;
import org.microemu.log.LoggerDataWrapper;
import org.microemu.log.LoggingEvent;
import org.microemu.log.StdOutAppender;

public class Logger {
    private static final String a = (g == null ? (g = Logger.a("org.microemu.log.Logger")) : g).getName();
    private static final Set b = new HashSet();
    private static final Set c = new HashSet();
    private static boolean d = false;
    private static boolean e = true;
    private static List f = new Vector();
    private static Class g;

    public static boolean isDebugEnabled() {
        return true;
    }

    public static boolean isErrorEnabled() {
        return true;
    }

    public static boolean isLocationEnabled() {
        return e;
    }

    public static void setLocationEnabled(boolean bl2) {
        e = bl2;
    }

    private static StackTraceElement a() {
        if (d || !e) {
            return null;
        }
        try {
            StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
            boolean bl2 = false;
            for (int i2 = 0; i2 < stackTraceElementArray.length - 1; ++i2) {
                if (b.contains(stackTraceElementArray[i2].getClassName())) {
                    bl2 = false;
                    String string = stackTraceElementArray[i2 + 1].getClassName();
                    if (string.startsWith("java.") || string.startsWith("sun.") || b.contains(string)) continue;
                    if (c.contains(stackTraceElementArray[i2 + 1].getMethodName())) {
                        bl2 = true;
                        continue;
                    }
                    if (string.startsWith("$Proxy")) {
                        return stackTraceElementArray[i2 + 2];
                    }
                    return stackTraceElementArray[i2 + 1];
                }
                if (!bl2 || c.contains(stackTraceElementArray[i2].getMethodName())) continue;
                return stackTraceElementArray[i2];
            }
            return stackTraceElementArray[stackTraceElementArray.length - 1];
        }
        catch (Throwable throwable) {
            d = true;
            return null;
        }
    }

    private static void a(int n2, String string, Throwable throwable) {
        while (string != null && string.endsWith("\n")) {
            string = string.substring(0, string.length() - 1);
        }
        Logger.a(new LoggingEvent(n2, string, Logger.a(), throwable));
    }

    private static void a(int n2, String string, Throwable throwable, Object object) {
        Logger.a(new LoggingEvent(n2, string, Logger.a(), throwable, object));
    }

    public static void debug(String string) {
        if (Logger.isDebugEnabled()) {
            Logger.a(1, string, null);
        }
    }

    public static void debug(String string, Throwable throwable) {
        if (Logger.isDebugEnabled()) {
            Logger.a(1, string, throwable);
        }
    }

    public static void debug(Throwable throwable) {
        if (Logger.isDebugEnabled()) {
            Logger.a(1, "error", throwable);
        }
    }

    public static void debug(String string, String string2) {
        if (Logger.isDebugEnabled()) {
            Logger.a(1, string, null, string2);
        }
    }

    public static void debug(String string, Object object) {
        if (Logger.isDebugEnabled()) {
            Logger.a(1, string, null, new LoggerDataWrapper(object));
        }
    }

    public static void debug(String string, String string2, String string3) {
        if (Logger.isDebugEnabled()) {
            Logger.a(1, string, null, new LoggerDataWrapper(string2, string3));
        }
    }

    public static void debug(String string, long l2) {
        if (Logger.isDebugEnabled()) {
            Logger.a(1, string, null, new LoggerDataWrapper(l2));
        }
    }

    public static void debug0x(String string, long l2) {
        if (Logger.isDebugEnabled()) {
            Logger.a(1, string, null, new LoggerDataWrapper("0x" + Long.toHexString(l2)));
        }
    }

    public static void debug(String string, long l2, long l3) {
        if (Logger.isDebugEnabled()) {
            Logger.a(1, string, null, new LoggerDataWrapper(l2, l3));
        }
    }

    public static void debug(String string, boolean bl2) {
        if (Logger.isDebugEnabled()) {
            Logger.a(1, string, null, new LoggerDataWrapper(bl2));
        }
    }

    public static void debugClassLoader(String clazz, Object object) {
        if (object == null) {
            Logger.a(1, (String)((Object)clazz) + " no class, no object", null, null);
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((String)((Object)clazz)).append(" ");
        if (object instanceof Class) {
            clazz = (Class)object;
            stringBuffer.append("class ");
        } else {
            clazz = object.getClass();
            stringBuffer.append("instance ");
        }
        stringBuffer.append(clazz.getName() + " loaded by ");
        if (clazz.getClassLoader() != null) {
            stringBuffer.append(clazz.getClassLoader().hashCode());
            stringBuffer.append(" ");
            stringBuffer.append(clazz.getClassLoader().getClass().getName());
        } else {
            stringBuffer.append("system");
        }
        Logger.a(1, stringBuffer.toString(), null, null);
    }

    public static void info(String string) {
        if (Logger.isErrorEnabled()) {
            Logger.a(2, string, null);
        }
    }

    public static void info(Object object) {
        if (Logger.isErrorEnabled()) {
            Logger.a(2, "" + object, null);
        }
    }

    public static void info(String string, String string2) {
        if (Logger.isErrorEnabled()) {
            Logger.a(2, string, null, string2);
        }
    }

    public static void warn(String string) {
        if (Logger.isErrorEnabled()) {
            Logger.a(3, string, null);
        }
    }

    public static void error(String string) {
        if (Logger.isErrorEnabled()) {
            Logger.a(4, "error " + string, null);
        }
    }

    public static void error(Object object) {
        if (Logger.isErrorEnabled()) {
            Logger.a(4, "error " + object, null);
        }
    }

    public static void error(String string, long l2) {
        if (Logger.isErrorEnabled()) {
            Logger.a(4, "error " + string, null, new LoggerDataWrapper(l2));
        }
    }

    public static void error(String string, String string2) {
        if (Logger.isErrorEnabled()) {
            Logger.a(4, "error " + string, null, string2);
        }
    }

    public static void error(String string, String string2, Throwable throwable) {
        if (Logger.isErrorEnabled()) {
            Logger.a(4, "error " + string, throwable, string2);
        }
    }

    public static void error(Throwable throwable) {
        if (Logger.isErrorEnabled()) {
            Logger.a(4, "error " + throwable.toString(), throwable);
        }
    }

    public static void error(String string, Throwable throwable) {
        if (Logger.isErrorEnabled()) {
            Logger.a(4, "error " + string + " " + throwable.toString(), throwable);
        }
    }

    private static void a(LoggingEvent loggingEvent) {
        Iterator iterator = f.iterator();
        while (iterator.hasNext()) {
            LoggerAppender loggerAppender = (LoggerAppender)iterator.next();
            loggerAppender.append(loggingEvent);
        }
    }

    public static void addLogOrigin(Class clazz) {
        b.add(clazz.getName());
    }

    public static void addAppender(LoggerAppender loggerAppender) {
        f.add(loggerAppender);
    }

    public static void removeAppender(LoggerAppender loggerAppender) {
        f.remove(loggerAppender);
    }

    public static void removeAllAppenders() {
        f.clear();
    }

    public static void threadDumpToConsole() {
        try {
            StringBuffer stringBuffer = new StringBuffer("Full ThreadDump\n");
            Object object = Thread.getAllStackTraces();
            object = object.entrySet().iterator();
            while (object.hasNext()) {
                StackTraceElement[] stackTraceElementArray = (StackTraceElement[])object.next();
                Thread thread = (Thread)stackTraceElementArray.getKey();
                stringBuffer.append("Thread= " + thread.getName() + " " + (thread.isDaemon() ? "daemon" : "") + " prio=" + thread.getPriority() + "id=" + thread.getId() + " " + (Object)((Object)thread.getState()));
                stringBuffer.append("\n");
                stackTraceElementArray = (StackTraceElement[])stackTraceElementArray.getValue();
                for (int i2 = 0; i2 < stackTraceElementArray.length; ++i2) {
                    stringBuffer.append("\t");
                    stringBuffer.append(stackTraceElementArray[i2].toString());
                    stringBuffer.append("\n");
                }
                stringBuffer.append("---------------------------------\n");
            }
            Logger.info(stringBuffer.toString());
            return;
        }
        catch (Throwable throwable) {
            return;
        }
    }

    public static void threadDumpToFile() {
        Serializable serializable = new SimpleDateFormat("MM-dd_HH-mm-ss");
        FileWriter fileWriter = null;
        try {
            serializable = new File("ThreadDump-" + ((DateFormat)serializable).format(new Date()) + ".log");
            fileWriter = new FileWriter((File)serializable);
            Object object = Thread.getAllStackTraces();
            object = object.entrySet().iterator();
            while (object.hasNext()) {
                StackTraceElement[] stackTraceElementArray = (StackTraceElement[])object.next();
                Thread thread = (Thread)stackTraceElementArray.getKey();
                fileWriter.write("Thread= " + thread.getName() + " " + (thread.isDaemon() ? "daemon" : "") + " prio=" + thread.getPriority() + "id=" + thread.getId() + " " + (Object)((Object)thread.getState()));
                fileWriter.write("\n");
                stackTraceElementArray = (StackTraceElement[])stackTraceElementArray.getValue();
                for (int i2 = 0; i2 < stackTraceElementArray.length; ++i2) {
                    fileWriter.write("\t");
                    fileWriter.write(stackTraceElementArray[i2].toString());
                    fileWriter.write("\n");
                }
                fileWriter.write("---------------------------------\n");
            }
            fileWriter.close();
            fileWriter = null;
            Logger.info("Full ThreadDump created " + ((File)serializable).getAbsolutePath());
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileWriter);
            return;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileWriter);
            throw throwable;
        }
        IOUtils.closeQuietly(null);
        return;
    }

    private static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        b.add(a);
        Logger.addAppender(new StdOutAppender());
        c.add("debug");
        c.add("log");
        c.add("error");
        c.add("fatal");
        c.add("info");
        c.add("warn");
    }
}

