/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.device.j2se;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.ImageProducer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Font;
import org.microemu.EmulatorContext;
import org.microemu.MIDletAccess;
import org.microemu.MIDletBridge;
import org.microemu.app.util.IOUtils;
import org.microemu.device.Device;
import org.microemu.device.DeviceFactory;
import org.microemu.device.MutableImage;
import org.microemu.device.impl.Button;
import org.microemu.device.impl.DeviceDisplayImpl;
import org.microemu.device.impl.PositionedImage;
import org.microemu.device.impl.Rectangle;
import org.microemu.device.impl.SoftButton;
import org.microemu.device.j2se.BWImageFilter;
import org.microemu.device.j2se.GrayImageFilter;
import org.microemu.device.j2se.J2SEButton;
import org.microemu.device.j2se.J2SEDisplayGraphics;
import org.microemu.device.j2se.J2SEImmutableImage;
import org.microemu.device.j2se.J2SEMutableImage;
import org.microemu.device.j2se.J2SESoftButton;
import org.microemu.device.j2se.RGBImageFilter;

public class J2SEDeviceDisplay
implements DeviceDisplayImpl {
    private EmulatorContext c;
    private Rectangle d;
    private Rectangle e;
    private boolean f;
    private int g;
    private int h;
    Color a;
    Color b;
    private PositionedImage i;
    private PositionedImage j;
    private PositionedImage k;
    private boolean l;

    public J2SEDeviceDisplay(EmulatorContext emulatorContext) {
        this.c = emulatorContext;
    }

    public MutableImage getDisplayImage() {
        return this.c.getDisplayComponent().getDisplayImage();
    }

    public int getHeight() {
        return this.e.height;
    }

    public int getWidth() {
        return this.e.width;
    }

    public int getFullHeight() {
        return this.d.height;
    }

    public int getFullWidth() {
        return this.d.width;
    }

    public boolean isColor() {
        return this.f;
    }

    public boolean isFullScreenMode() {
        Object object = MIDletBridge.getMIDletAccess();
        if (object == null) {
            return false;
        }
        if ((object = ((MIDletAccess)object).getDisplayAccess()) == null) {
            return false;
        }
        return object.isFullScreenMode();
    }

    public int numAlphaLevels() {
        return this.h;
    }

    public int numColors() {
        return this.g;
    }

    public void paintControls(Graphics graphics) {
        Device device = DeviceFactory.getDevice();
        graphics.setColor(this.a);
        graphics.fillRect(0, 0, this.d.width, this.e.y);
        graphics.fillRect(0, this.e.y, this.e.x, this.e.height);
        graphics.fillRect(this.e.x + this.e.width, this.e.y, this.d.width - this.e.x - this.e.width, this.e.height);
        graphics.fillRect(0, this.e.y + this.e.height, this.d.width, this.d.height - this.e.y - this.e.height);
        graphics.setColor(this.b);
        Enumeration enumeration = device.getSoftButtons().elements();
        while (enumeration.hasMoreElements()) {
            ((J2SESoftButton)enumeration.nextElement()).paint(graphics);
        }
        int n2 = device.getInputMethod().getInputMode();
        if (n2 == 1) {
            graphics.drawImage(((J2SEImmutableImage)this.i.getImage()).getImage(), this.i.getRectangle().x, this.i.getRectangle().y, null);
            return;
        }
        if (n2 == 2) {
            graphics.drawImage(((J2SEImmutableImage)this.j.getImage()).getImage(), this.j.getRectangle().x, this.j.getRectangle().y, null);
            return;
        }
        if (n2 == 3) {
            graphics.drawImage(((J2SEImmutableImage)this.k.getImage()).getImage(), this.k.getRectangle().x, this.k.getRectangle().y, null);
        }
    }

    public void paintDisplayable(Graphics graphics, int n2, int n3, int n4, int n5) {
        MIDletAccess mIDletAccess = MIDletBridge.getMIDletAccess();
        if (mIDletAccess == null) {
            return;
        }
        Object object = mIDletAccess.getDisplayAccess();
        if (object == null) {
            return;
        }
        if ((object = object.getCurrent()) == null) {
            return;
        }
        graphics.setColor(this.b);
        Shape shape = graphics.getClip();
        if (!(object instanceof Canvas) || ((Canvas)object).getWidth() != this.d.width || ((Canvas)object).getHeight() != this.d.height) {
            graphics.translate(this.e.x, this.e.y);
        }
        graphics.setClip(n2, n3, n4, n5);
        java.awt.Font font = graphics.getFont();
        mIDletAccess.getDisplayAccess().paint(new J2SEDisplayGraphics((Graphics2D)graphics, this.getDisplayImage()));
        graphics.setFont(font);
        if (!(object instanceof Canvas) || ((Canvas)object).getWidth() != this.d.width || ((Canvas)object).getHeight() != this.d.height) {
            graphics.translate(-this.e.x, -this.e.y);
        }
        graphics.setClip(shape);
    }

    public void repaint(int n2, int n3, int n4, int n5) {
        this.c.getDisplayComponent().repaintRequest(n2, n3, n4, n5);
    }

    public void setScrollDown(boolean bl2) {
        Enumeration enumeration = DeviceFactory.getDevice().getSoftButtons().elements();
        while (enumeration.hasMoreElements()) {
            SoftButton softButton = (SoftButton)enumeration.nextElement();
            if (softButton.getType() != 2 || !softButton.getName().equals("down")) continue;
            softButton.setVisible(bl2);
        }
    }

    public void setScrollUp(boolean bl2) {
        Enumeration enumeration = DeviceFactory.getDevice().getSoftButtons().elements();
        while (enumeration.hasMoreElements()) {
            SoftButton softButton = (SoftButton)enumeration.nextElement();
            if (softButton.getType() != 2 || !softButton.getName().equals("up")) continue;
            softButton.setVisible(bl2);
        }
    }

    public boolean isResizable() {
        return this.l;
    }

    public void setResizable(boolean bl2) {
        this.l = bl2;
    }

    public Rectangle getDisplayRectangle() {
        return this.d;
    }

    public Rectangle getDisplayPaintable() {
        return this.e;
    }

    public org.microemu.device.impl.Color getBackgroundColor() {
        return new org.microemu.device.impl.Color(this.a.getRGB());
    }

    public org.microemu.device.impl.Color getForegroundColor() {
        return new org.microemu.device.impl.Color(this.b.getRGB());
    }

    public javax.microedition.lcdui.Image createImage(int n2, int n3) {
        if (n2 <= 0 || n3 <= 0) {
            throw new IllegalArgumentException();
        }
        return new J2SEMutableImage(n2, n3);
    }

    public javax.microedition.lcdui.Image createImage(String string) {
        return this.a(string);
    }

    public javax.microedition.lcdui.Image createImage(javax.microedition.lcdui.Image image) {
        if (image.isMutable()) {
            return new J2SEImmutableImage((J2SEMutableImage)image);
        }
        return image;
    }

    public javax.microedition.lcdui.Image createImage(InputStream inputStream) {
        if (inputStream == null) {
            throw new IOException();
        }
        return this.a(inputStream);
    }

    public javax.microedition.lcdui.Image createRGBImage(int[] nArray, int n2, int n3, boolean n4) {
        Object object;
        if (nArray == null) {
            throw new NullPointerException();
        }
        if (n2 <= 0 || n3 <= 0) {
            throw new IllegalArgumentException();
        }
        BufferedImage bufferedImage = new BufferedImage(n2, n3, 2);
        if (!n4) {
            n4 = nArray.length;
            object = new int[n4];
            for (int i2 = 0; i2 < n4; ++i2) {
                object[i2] = nArray[i2] | 0xFF000000;
            }
            nArray = object;
        }
        bufferedImage.setRGB(0, 0, n2, n3, nArray, 0, n2);
        java.awt.image.RGBImageFilter rGBImageFilter = null;
        if (this.isColor()) {
            if (this.a.getRed() != 255 || this.a.getGreen() != 255 || this.a.getBlue() != 255 || this.b.getRed() != 0 || this.b.getGreen() != 0 || this.b.getBlue() != 0) {
                rGBImageFilter = new RGBImageFilter();
            }
        } else {
            rGBImageFilter = this.numColors() == 2 ? new BWImageFilter() : new GrayImageFilter();
        }
        if (rGBImageFilter != null) {
            object = new FilteredImageSource(bufferedImage.getSource(), rGBImageFilter);
            return new J2SEImmutableImage(Toolkit.getDefaultToolkit().createImage((ImageProducer)object));
        }
        return new J2SEImmutableImage(bufferedImage);
    }

    public javax.microedition.lcdui.Image createImage(javax.microedition.lcdui.Image image, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        if (image == null) {
            throw new NullPointerException();
        }
        if (n2 + n4 > image.getWidth() || n3 + n5 > image.getHeight() || n4 <= 0 || n5 <= 0 || n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("Area out of Image");
        }
        int[] nArray = new int[n5 * n4];
        int[] nArray2 = new int[n5 * n4];
        if (image instanceof J2SEImmutableImage) {
            ((J2SEImmutableImage)image).getRGB(nArray, 0, n4, n2, n3, n4, n5);
        } else {
            ((J2SEMutableImage)image).getRGB(nArray, 0, n4, n2, n3, n4, n5);
        }
        switch (n6) {
            case 0: {
                n3 = 0;
                n7 = 1;
                n2 = 0;
                break;
            }
            case 5: {
                n3 = (n5 - 1) * n4;
                n7 = -n4;
                n2 = n5 * n4 + 1;
                n6 = n4;
                n4 = n5;
                n5 = n6;
                break;
            }
            case 3: {
                n3 = n5 * n4 - 1;
                n7 = -1;
                n2 = 0;
                break;
            }
            case 6: {
                n3 = n4 - 1;
                n7 = n4;
                n2 = -(n5 * n4) - 1;
                n4 = n5;
                n5 = n7;
                break;
            }
            case 2: {
                n3 = n4 - 1;
                n7 = -1;
                n2 = n4 << 1;
                break;
            }
            case 7: {
                n3 = n5 * n4 - 1;
                n7 = -n4;
                n2 = n3;
                n6 = n4;
                n4 = n5;
                n5 = n6;
                break;
            }
            case 1: {
                n3 = (n5 - 1) * n4;
                n7 = 1;
                n2 = -(n4 << 1);
                break;
            }
            case 4: {
                n3 = 0;
                n7 = n4;
                n2 = -(n5 * n4) + 1;
                n4 = n5;
                n5 = n7;
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad transform");
            }
        }
        n6 = 0;
        int n8 = 0;
        while (n6 < n5) {
            int n9 = 0;
            while (n9 < n4) {
                nArray2[n8] = nArray[n3];
                ++n9;
                n3 += n7;
                ++n8;
            }
            ++n6;
            n3 += n2;
        }
        return this.createRGBImage(nArray2, n4, n5, true);
    }

    public javax.microedition.lcdui.Image createImage(byte[] object, int n2, int n3) {
        object = new ByteArrayInputStream((byte[])object, n2, n3);
        try {
            return this.a((InputStream)object);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException(iOException.toString());
        }
    }

    public void setNumAlphaLevels(int n2) {
        this.h = n2;
    }

    public void setNumColors(int n2) {
        this.g = n2;
    }

    public void setIsColor(boolean bl2) {
        this.f = bl2;
    }

    public void setBackgroundColor(org.microemu.device.impl.Color color) {
        this.a = new Color(color.getRGB());
    }

    public void setForegroundColor(org.microemu.device.impl.Color color) {
        this.b = new Color(color.getRGB());
    }

    public void setDisplayRectangle(Rectangle rectangle) {
        this.d = rectangle;
    }

    public void setDisplayPaintable(Rectangle rectangle) {
        this.e = rectangle;
    }

    public void setMode123Image(PositionedImage positionedImage) {
        this.i = positionedImage;
    }

    public void setModeAbcLowerImage(PositionedImage positionedImage) {
        this.k = positionedImage;
    }

    public void setModeAbcUpperImage(PositionedImage positionedImage) {
        this.j = positionedImage;
    }

    public javax.microedition.lcdui.Image createSystemImage(URL object) {
        object = Toolkit.getDefaultToolkit().createImage((URL)object);
        MediaTracker mediaTracker = new MediaTracker(new java.awt.Canvas());
        mediaTracker.addImage((Image)object, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {}
        if (mediaTracker.isErrorID(0)) {
            throw new IOException();
        }
        return new J2SEImmutableImage((Image)object);
    }

    private javax.microedition.lcdui.Image a(String object) {
        Object object2 = MIDletBridge.getCurrentMIDlet();
        if (object2 == null) {
            object2 = this.getClass();
        }
        if ((object2 = object2.getClass().getResourceAsStream((String)object)) == null) {
            throw new IOException((String)object + " could not be found.");
        }
        try {
            object = this.a((InputStream)object2);
            return object;
        }
        finally {
            IOUtils.closeQuietly((InputStream)object2);
        }
    }

    private javax.microedition.lcdui.Image a(InputStream object) {
        int n2;
        Object object2 = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n2 = ((InputStream)object).read((byte[])object2)) != -1) {
            byteArrayOutputStream.write((byte[])object2, 0, n2);
        }
        object = Toolkit.getDefaultToolkit().createImage(byteArrayOutputStream.toByteArray());
        object2 = null;
        if (this.isColor()) {
            if (this.a.getRed() != 255 || this.a.getGreen() != 255 || this.a.getBlue() != 255 || this.b.getRed() != 0 || this.b.getGreen() != 0 || this.b.getBlue() != 0) {
                object2 = new RGBImageFilter();
            }
        } else {
            object2 = this.numColors() == 2 ? (Object)new BWImageFilter() : (Object)new GrayImageFilter();
        }
        if (object2 != null) {
            object2 = new FilteredImageSource(((Image)object).getSource(), (ImageFilter)object2);
            object = Toolkit.getDefaultToolkit().createImage((ImageProducer)object2);
        }
        MediaTracker mediaTracker = new MediaTracker(new java.awt.Canvas());
        object2 = mediaTracker;
        mediaTracker.addImage((Image)object, 0);
        try {
            ((MediaTracker)object2).waitForID(0);
        }
        catch (InterruptedException interruptedException) {}
        if (((MediaTracker)object2).isErrorID(0)) {
            throw new IOException();
        }
        return new J2SEImmutableImage((Image)object);
    }

    public Button createButton(int n2, String string, org.microemu.device.impl.Shape shape, int n3, String string2, String string3, Hashtable hashtable, boolean bl2) {
        return new J2SEButton(n2, string, shape, n3, string2, string3, hashtable, bl2);
    }

    public SoftButton createSoftButton(int n2, String string, org.microemu.device.impl.Shape shape, int n3, String string2, Rectangle rectangle, String string3, Vector vector, Font font) {
        return new J2SESoftButton(n2, string, shape, n3, string2, rectangle, string3, vector, font);
    }

    public SoftButton createSoftButton(int n2, String string, Rectangle rectangle, javax.microedition.lcdui.Image image, javax.microedition.lcdui.Image image2) {
        return new J2SESoftButton(n2, string, rectangle, image, image2);
    }
}

