/*
 * Decompiled with CFR 0.152.
 */
package org.microemu.cldc.socket;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class SocketConnection
implements javax.microedition.io.SocketConnection {
    protected Socket socket;

    public SocketConnection() {
    }

    public SocketConnection(String string, int n2) {
        this.socket = new Socket(string, n2);
    }

    public SocketConnection(Socket socket) {
        this.socket = socket;
    }

    public String getAddress() {
        if (this.socket == null || this.socket.isClosed()) {
            throw new IOException();
        }
        return this.socket.getInetAddress().toString();
    }

    public String getLocalAddress() {
        if (this.socket == null || this.socket.isClosed()) {
            throw new IOException();
        }
        return this.socket.getLocalAddress().toString();
    }

    public int getLocalPort() {
        if (this.socket == null || this.socket.isClosed()) {
            throw new IOException();
        }
        return this.socket.getLocalPort();
    }

    public int getPort() {
        if (this.socket == null || this.socket.isClosed()) {
            throw new IOException();
        }
        return this.socket.getPort();
    }

    public int getSocketOption(byte by2) {
        if (this.socket != null && this.socket.isClosed()) {
            throw new IOException();
        }
        switch (by2) {
            case 0: {
                if (this.socket.getTcpNoDelay()) {
                    return 1;
                }
                return 0;
            }
            case 1: {
                int n2 = this.socket.getSoLinger();
                by2 = (byte)n2;
                if (n2 == -1) {
                    return 0;
                }
                return by2;
            }
            case 2: {
                if (this.socket.getKeepAlive()) {
                    return 1;
                }
                return 0;
            }
            case 3: {
                return this.socket.getReceiveBufferSize();
            }
            case 4: {
                return this.socket.getSendBufferSize();
            }
        }
        throw new IllegalArgumentException();
    }

    public void setSocketOption(byte by2, int n2) {
        if (this.socket.isClosed()) {
            throw new IOException();
        }
        switch (by2) {
            case 0: {
                by2 = n2 == 0 ? (byte)0 : 1;
                this.socket.setTcpNoDelay(by2 != 0);
                return;
            }
            case 1: {
                if (n2 < 0) {
                    throw new IllegalArgumentException();
                }
                this.socket.setSoLinger(n2 != 0, n2);
                return;
            }
            case 2: {
                by2 = n2 == 0 ? (byte)0 : 1;
                this.socket.setKeepAlive(by2 != 0);
                return;
            }
            case 3: {
                if (n2 <= 0) {
                    throw new IllegalArgumentException();
                }
                this.socket.setReceiveBufferSize(n2);
                return;
            }
            case 4: {
                if (n2 <= 0) {
                    throw new IllegalArgumentException();
                }
                this.socket.setSendBufferSize(n2);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    public void close() {
        this.socket.close();
    }

    public InputStream openInputStream() {
        return this.socket.getInputStream();
    }

    public DataInputStream openDataInputStream() {
        return new DataInputStream(this.openInputStream());
    }

    public OutputStream openOutputStream() {
        return this.socket.getOutputStream();
    }

    public DataOutputStream openDataOutputStream() {
        return new DataOutputStream(this.openOutputStream());
    }
}

