/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui.game;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.TiledLayer;

public class Sprite
extends Layer {
    public static final int TRANS_NONE = 0;
    public static final int TRANS_ROT90 = 5;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_ROT270 = 6;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_MIRROR_ROT90 = 7;
    public static final int TRANS_MIRROR_ROT180 = 1;
    public static final int TRANS_MIRROR_ROT270 = 4;
    private int frame;
    private int[] sequence;
    private int refX;
    private int refY;
    private int cols;
    private int rows;
    private int transform;
    private Image img;
    private int collX;
    private int collY;
    private int collWidth;
    private int collHeight;
    private int[] rgbData;
    private int[] rgbDataAux;

    public Sprite(Image image) {
        Image image2 = image;
        this(image2, image2.getWidth(), image.getHeight());
    }

    public Sprite(Image image, int n2, int n3) {
        super(0, 0, n2, n3, true);
        if (image.getWidth() % n2 != 0 || image.getHeight() % n3 != 0) {
            throw new IllegalArgumentException();
        }
        this.img = image;
        this.cols = image.getWidth() / n2;
        this.rows = image.getHeight() / n3;
        Sprite sprite = this;
        sprite.collY = 0;
        sprite.collX = 0;
        this.collWidth = n2;
        this.collHeight = n3;
    }

    public Sprite(Sprite sprite) {
        super(sprite.getX(), sprite.getY(), sprite.getWidth(), sprite.getHeight(), sprite.isVisible());
        this.frame = sprite.frame;
        this.sequence = sprite.sequence;
        this.refX = sprite.refX;
        this.refY = sprite.refY;
        this.cols = sprite.cols;
        this.rows = sprite.rows;
        this.transform = sprite.transform;
        this.img = sprite.img;
        this.collX = sprite.collX;
        this.collY = sprite.collY;
        this.collWidth = sprite.collWidth;
        this.collHeight = sprite.collHeight;
    }

    public final boolean collidesWith(Image image, int n2, int n3, boolean bl2) {
        if (image == null) {
            throw new IllegalArgumentException();
        }
        if (!this.isVisible()) {
            return false;
        }
        if (bl2) {
            return this.collidesWithPixelLevel(image, n2, n3);
        }
        return this.collidesWith(image, n2, n3);
    }

    public final boolean collidesWith(TiledLayer tiledLayer, boolean bl2) {
        if (tiledLayer == null) {
            throw new NullPointerException();
        }
        if (!this.isVisible()) {
            return false;
        }
        if (!tiledLayer.isVisible() || !this.isVisible()) {
            return false;
        }
        if (bl2) {
            return this.collidesWithPixelLevel(tiledLayer, 0, 0);
        }
        return this.collidesWith(tiledLayer, 0, 0);
    }

    public final boolean collidesWith(Sprite sprite, boolean bl2) {
        if (sprite == null) {
            throw new NullPointerException();
        }
        if (!sprite.isVisible() || !this.isVisible()) {
            return false;
        }
        if (bl2) {
            return this.collidesWithPixelLevel(sprite, 0, 0);
        }
        return this.collidesWith(sprite, 0, 0);
    }

    public void defineReferencePixel(int n2, int n3) {
        this.refX = n2;
        this.refY = n3;
    }

    public int getRefPixelX() {
        return this.getX() + this.refX;
    }

    public int getRefPixelY() {
        return this.getY() + this.refY;
    }

    public void setRefPixelPosition(int n2, int n3) {
        int n4;
        int n5 = this.getWidth();
        int n6 = this.getHeight();
        switch (this.transform) {
            case 0: {
                n4 = this.refX;
                n5 = this.refY;
                break;
            }
            case 1: {
                n4 = n5 - this.refX;
                n5 = n6 - this.refY;
                break;
            }
            case 2: {
                n4 = n5 - this.refX;
                n5 = this.refY;
                break;
            }
            case 3: {
                n4 = this.refX;
                n5 = n6 - this.refY;
                break;
            }
            case 4: {
                n4 = n6 - this.refY;
                n5 = this.refX;
                break;
            }
            case 5: {
                n4 = n6 - this.refY;
                n5 -= this.refX;
                break;
            }
            case 6: {
                n4 = this.refY;
                n5 = this.refX;
                break;
            }
            case 7: {
                n4 = this.refY;
                n5 -= this.refX;
                break;
            }
            default: {
                return;
            }
        }
        this.setPosition(n2 - n4, n3 - n5);
    }

    public void defineCollisionRectangle(int n2, int n3, int n4, int n5) {
        if (n4 < 0 || n5 < 0) {
            throw new IllegalArgumentException();
        }
        this.collX = n2;
        this.collY = n3;
        this.collWidth = n4;
        this.collHeight = n5;
    }

    public void setFrameSequence(int[] nArray) {
        if (nArray == null) {
            this.sequence = null;
            return;
        }
        int n2 = this.rows * this.cols - 1;
        int n3 = nArray.length;
        if (n3 == 0) {
            throw new IllegalArgumentException();
        }
        for (int i2 = 0; i2 < n3; ++i2) {
            int n4 = nArray[i2];
            if (n4 <= n2 && n4 >= 0) continue;
            throw new ArrayIndexOutOfBoundsException();
        }
        this.sequence = nArray;
        this.frame = 0;
    }

    public final int getFrame() {
        return this.frame;
    }

    public int getFrameSequenceLength() {
        if (this.sequence == null) {
            return this.rows * this.cols;
        }
        return this.sequence.length;
    }

    public void setFrame(int n2) {
        int n3;
        int n4 = n3 = this.sequence == null ? this.rows * this.cols : this.sequence.length;
        if (n2 < 0 || n2 >= n3) {
            throw new IndexOutOfBoundsException();
        }
        this.frame = n2;
    }

    public void nextFrame() {
        if (this.frame == (this.sequence == null ? this.rows * this.cols : this.sequence.length) - 1) {
            this.frame = 0;
            return;
        }
        ++this.frame;
    }

    public void prevFrame() {
        if (this.frame == 0) {
            this.frame = (this.sequence == null ? this.rows * this.cols : this.sequence.length) - 1;
            return;
        }
        --this.frame;
    }

    public void setImage(Image image, int n2, int n3) {
        Sprite sprite = this;
        synchronized (sprite) {
            int n4 = this.getWidth();
            int n5 = this.getHeight();
            int n6 = image.getWidth();
            int n7 = image.getHeight();
            this.setSize(n2, n3);
            if (image.getWidth() % n2 != 0 || image.getHeight() % n3 != 0) {
                throw new IllegalArgumentException();
            }
            this.img = image;
            int n8 = this.cols * this.rows;
            this.cols = image.getWidth() / n2;
            this.rows = image.getHeight() / n3;
            if (this.rows * this.cols < n8) {
                this.sequence = null;
                this.frame = 0;
            }
            if (n2 != this.getWidth() || n3 != this.getHeight()) {
                this.defineCollisionRectangle(0, 0, n2, n3);
                Sprite sprite2 = this;
                sprite2.rgbDataAux = null;
                sprite2.rgbData = null;
                if (this.transform != 0) {
                    int n9;
                    switch (this.transform) {
                        case 1: {
                            n9 = n6 - n4;
                            n2 = n7 - n5;
                            break;
                        }
                        case 2: {
                            n9 = n6 - n4;
                            n2 = 0;
                            break;
                        }
                        case 3: {
                            n9 = 0;
                            n2 = n7 - n5;
                            break;
                        }
                        case 4: {
                            n9 = n7 - n5;
                            n2 = 0;
                            break;
                        }
                        case 5: {
                            n9 = n7 - n5;
                            n2 = n6 - n4;
                            break;
                        }
                        case 6: {
                            n9 = 0;
                            n2 = 0;
                            break;
                        }
                        case 7: {
                            n9 = 0;
                            n2 = n6 - n4;
                            break;
                        }
                        default: {
                            return;
                        }
                    }
                    this.move(n9, n2);
                }
            }
            return;
        }
    }

    public final void paint(Graphics graphics) {
        if (!this.isVisible()) {
            return;
        }
        int n2 = this.sequence == null ? this.frame : this.sequence[this.frame];
        int n3 = this.getWidth();
        int n4 = this.getHeight();
        int n5 = n3 * (n2 % this.cols);
        n2 = n4 * (n2 / this.cols);
        graphics.drawRegion(this.img, n5, n2, n3, n4, this.transform, this.getX(), this.getY(), 20);
    }

    public int getRawFrameCount() {
        return this.cols * this.rows;
    }

    public void setTransform(int n2) {
        int n3;
        int n4;
        if (this.transform == n2) {
            return;
        }
        int n5 = this.getWidth();
        int n6 = this.getHeight();
        int n7 = this.transform;
        switch (n2) {
            case 0: {
                n4 = this.refX;
                n3 = this.refY;
                break;
            }
            case 1: {
                n4 = n5 - this.refX;
                n3 = n6 - this.refY;
                break;
            }
            case 2: {
                n4 = n5 - this.refX;
                n3 = this.refY;
                break;
            }
            case 3: {
                n4 = this.refX;
                n3 = n6 - this.refY;
                break;
            }
            case 4: {
                n4 = n6 - this.refY;
                n3 = this.refX;
                break;
            }
            case 5: {
                n4 = n6 - this.refY;
                n3 = n5 - this.refX;
                break;
            }
            case 6: {
                n4 = this.refY;
                n3 = this.refX;
                break;
            }
            case 7: {
                n4 = this.refY;
                n3 = n5 - this.refX;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        switch (n7) {
            case 0: {
                n7 = this.refX;
                n5 = this.refY;
                break;
            }
            case 1: {
                n7 = n5 - this.refX;
                n5 = n6 - this.refY;
                break;
            }
            case 2: {
                n7 = n5 - this.refX;
                n5 = this.refY;
                break;
            }
            case 3: {
                n7 = this.refX;
                n5 = n6 - this.refY;
                break;
            }
            case 4: {
                n7 = n6 - this.refY;
                n5 = this.refX;
                break;
            }
            case 5: {
                n7 = n6 - this.refY;
                n5 -= this.refX;
                break;
            }
            case 6: {
                n7 = this.refY;
                n5 = this.refX;
                break;
            }
            case 7: {
                n7 = this.refY;
                n5 -= this.refX;
                break;
            }
            default: {
                return;
            }
        }
        this.move(n7 - n4, n5 - n3);
        this.transform = n2;
    }

    private synchronized boolean collidesWith(Object object, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        Sprite sprite = this;
        boolean bl2 = true;
        while (bl2) {
            int n16;
            n9 = sprite.collX;
            n8 = sprite.collY;
            n7 = sprite.collWidth;
            n6 = sprite.collHeight;
            if (n7 == 0 || n6 == 0) {
                return false;
            }
            switch (sprite.transform) {
                case 0: {
                    n16 = sprite.getX() + n9;
                    n8 = sprite.getY() + n8;
                    n5 = n7;
                    n4 = n6;
                    break;
                }
                case 1: {
                    n16 = sprite.getX() + n9;
                    n8 = sprite.getY() + (sprite.getHeight() - n8 - 1) - n6;
                    n5 = n7;
                    n4 = n6;
                    break;
                }
                case 2: {
                    n16 = sprite.getX() + (sprite.getWidth() - n9 - 1) - n7;
                    n8 = sprite.getY() + n8;
                    n5 = n7;
                    n4 = n6;
                    break;
                }
                case 3: {
                    n16 = sprite.getX() + (sprite.getWidth() - n9 - 1) - n7;
                    n8 = sprite.getY() + (sprite.getHeight() - n8 - 1) - n6;
                    n5 = n7;
                    n4 = n6;
                    break;
                }
                case 4: {
                    n16 = sprite.getX() + n8;
                    n8 = sprite.getY() + n9;
                    n5 = n6;
                    n4 = n7;
                    break;
                }
                case 5: {
                    n16 = sprite.getX() + (sprite.getHeight() - n8 - 1) - n6;
                    n8 = sprite.getY() + n9;
                    n5 = n6;
                    n4 = n7;
                    break;
                }
                case 7: {
                    n16 = sprite.getX() + (sprite.getHeight() - n8 - 1) - n6;
                    n8 = sprite.getY() + (sprite.getWidth() - n9 - 1) - n7;
                    n5 = n6;
                    n4 = n7;
                    break;
                }
                case 6: {
                    n16 = sprite.getX() + n8;
                    n8 = sprite.getY() + (sprite.getWidth() - n9 - 1) - n7;
                    n5 = n6;
                    n4 = n7;
                    break;
                }
                default: {
                    return false;
                }
            }
            if (object != sprite) {
                n10 = n16;
                n11 = n8;
                n12 = n5;
                n13 = n4;
                if (object instanceof Sprite) {
                    sprite = (Sprite)object;
                    continue;
                }
                if (object instanceof TiledLayer) {
                    bl2 = false;
                    TiledLayer tiledLayer = (TiledLayer)object;
                    n2 = tiledLayer.getX();
                    n3 = tiledLayer.getY();
                    n14 = tiledLayer.getWidth();
                    n15 = tiledLayer.getHeight();
                    continue;
                }
                bl2 = false;
                Image image = (Image)object;
                n14 = image.getWidth();
                n15 = image.getHeight();
                continue;
            }
            bl2 = false;
            n2 = n16;
            n3 = n8;
            n14 = n5;
            n15 = n4;
        }
        if (n10 > n2 && n10 >= n2 + n14) {
            return false;
        }
        if (n10 < n2 && n10 + n12 <= n2) {
            return false;
        }
        if (n11 > n3 && n11 >= n3 + n15) {
            return false;
        }
        if (n11 < n3 && n11 + n13 <= n3) {
            return false;
        }
        if (object instanceof TiledLayer) {
            TiledLayer tiledLayer = (TiledLayer)object;
            if (n2 > n10) {
                n8 = n2;
                n4 = (n2 + n14 < n10 + n12 ? n2 + n14 : n10 + n12) - n8;
            } else {
                n8 = n10;
                n4 = (n10 + n12 < n2 + n14 ? n10 + n12 : n2 + n14) - n8;
            }
            if (n3 > n11) {
                n5 = n3;
                n9 = (n3 + n15 < n11 + n13 ? n3 + n15 : n11 + n13) - n5;
            } else {
                n5 = n11;
                n9 = (n11 + n13 < n3 + n15 ? n11 + n13 : n3 + n15) - n5;
            }
            n7 = tiledLayer.getCellWidth();
            n6 = tiledLayer.getCellHeight();
            n15 = (n8 - n2) / n7;
            int n17 = (n5 - n3) / n6;
            n2 = (n8 - n2 + n4 - 1) / n7;
            n3 = (n5 - n3 + n9 - 1) / n6;
            while (n17 <= n3) {
                for (n10 = n15; n10 <= n2; ++n10) {
                    n11 = tiledLayer.getCell(n10, n17);
                    if (n11 < 0) {
                        n11 = tiledLayer.getAnimatedTile(n11);
                    }
                    if (n11 == 0) continue;
                    return true;
                }
                ++n17;
            }
            return false;
        }
        return true;
    }

    private synchronized boolean collidesWithPixelLevel(Object object, int n2, int n3) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        int n12;
        int n13;
        boolean bl2 = true;
        Sprite sprite = this;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        while (bl2) {
            if (sprite.collX >= sprite.getWidth() || sprite.collX + sprite.collWidth <= 0 || sprite.collY >= sprite.getHeight() || sprite.collY + sprite.collHeight <= 0) {
                return false;
            }
            n13 = sprite.collX >= 0 ? sprite.collX : 0;
            n12 = sprite.collY >= 0 ? sprite.collY : 0;
            n11 = sprite.collX + sprite.collWidth < sprite.getWidth() ? sprite.collX + sprite.collWidth - n13 : sprite.getWidth() - n13;
            n10 = sprite.collY + sprite.collHeight < sprite.getHeight() ? sprite.collY + sprite.collHeight - n12 : sprite.getHeight() - n12;
            switch (sprite.transform) {
                case 0: {
                    n9 = sprite.getX() + n13;
                    n8 = sprite.getY() + n12;
                    n7 = n11;
                    n6 = n10;
                    break;
                }
                case 1: {
                    n9 = sprite.getX() + n13;
                    n8 = sprite.getY() + (sprite.getHeight() - n12 - 1) - n10;
                    n7 = n11;
                    n6 = n10;
                    break;
                }
                case 2: {
                    n9 = sprite.getX() + (sprite.getWidth() - n13 - 1) - n11;
                    n8 = sprite.getY() + n12;
                    n7 = n11;
                    n6 = n10;
                    break;
                }
                case 3: {
                    n9 = sprite.getX() + (sprite.getWidth() - n13 - 1) - n11;
                    n8 = sprite.getY() + (sprite.getHeight() - n12 - 1) - n10;
                    n7 = n11;
                    n6 = n10;
                    break;
                }
                case 4: {
                    n9 = sprite.getX() + n12;
                    n8 = sprite.getY() + n13;
                    n7 = n10;
                    n6 = n11;
                    break;
                }
                case 5: {
                    n9 = sprite.getX() + (sprite.getHeight() - n12) - n10;
                    n8 = sprite.getY() + n13;
                    n7 = n10;
                    n6 = n11;
                    break;
                }
                case 7: {
                    n9 = sprite.getX() + (sprite.getHeight() - n12) - n10;
                    n8 = sprite.getY() + (sprite.getWidth() - n13) - n11;
                    n7 = n10;
                    n6 = n11;
                    break;
                }
                case 6: {
                    n9 = sprite.getX() + n12;
                    n8 = sprite.getY() + (sprite.getWidth() - n13) - n11;
                    n7 = n10;
                    n6 = n11;
                    break;
                }
                default: {
                    return false;
                }
            }
            if (object != sprite) {
                n14 = n9;
                n15 = n8;
                n16 = n7;
                n17 = n6;
                if (object instanceof Sprite) {
                    sprite = (Sprite)object;
                    continue;
                }
                if (object instanceof TiledLayer) {
                    bl2 = false;
                    TiledLayer tiledLayer = (TiledLayer)object;
                    n2 = tiledLayer.getX();
                    n3 = tiledLayer.getY();
                    n18 = tiledLayer.getWidth();
                    n19 = tiledLayer.getHeight();
                    continue;
                }
                bl2 = false;
                Image image = (Image)object;
                n18 = image.getWidth();
                n19 = image.getHeight();
                continue;
            }
            bl2 = false;
            n2 = n9;
            n3 = n8;
            n18 = n7;
            n19 = n6;
        }
        if (n14 > n2 && n14 >= n2 + n18) {
            return false;
        }
        if (n14 < n2 && n14 + n16 <= n2) {
            return false;
        }
        if (n15 > n3 && n15 >= n3 + n19) {
            return false;
        }
        if (n15 < n3 && n15 + n17 <= n3) {
            return false;
        }
        if (n2 > n14) {
            n13 = n2;
            n11 = (n2 + n18 < n14 + n16 ? n2 + n18 : n14 + n16) - n13;
        } else {
            n13 = n14;
            n11 = (n14 + n16 < n2 + n18 ? n14 + n16 : n2 + n18) - n13;
        }
        if (n3 > n15) {
            n12 = n3;
            n10 = (n3 + n19 < n15 + n17 ? n3 + n19 : n15 + n17) - n12;
        } else {
            n12 = n15;
            n10 = (n15 + n17 < n3 + n19 ? n15 + n17 : n3 + n19) - n12;
        }
        n9 = 0;
        n8 = 0;
        n7 = 0;
        n6 = 0;
        n19 = 0;
        n14 = 0;
        n15 = this.sequence == null ? this.frame : this.sequence[this.frame];
        n16 = this.getWidth();
        n17 = this.getHeight();
        n18 = n16 * (n15 % this.rows);
        n15 = n17 * (n15 / this.rows);
        if (this.rgbData == null) {
            this.rgbData = new int[n16 * n17];
            this.rgbDataAux = new int[n16 * n17];
        }
        sprite = this;
        bl2 = true;
        int[] nArray = this.rgbData;
        while (bl2) {
            int n20;
            switch (sprite.transform) {
                case 0: {
                    sprite.img.getRGB(nArray, 0, n11, n18 + n13 - sprite.getX(), n15 + n12 - sprite.getY(), n11, n10);
                    n20 = 0;
                    n5 = 1;
                    n4 = 0;
                    break;
                }
                case 3: {
                    sprite.img.getRGB(nArray, 0, n11, n18 + n16 - (n13 - sprite.getX()) - n11 - 1, n15 + n17 - (n12 - sprite.getY()) - n10 - 1, n11, n10);
                    n20 = n10 * n11 - 1;
                    n5 = -1;
                    n4 = 0;
                    break;
                }
                case 2: {
                    sprite.img.getRGB(nArray, 0, n11, n18 + n16 - (n13 - sprite.getX()) - n11 - 1, n15 + n12 - sprite.getY(), n11, n10);
                    n20 = n11 - 1;
                    n5 = -1;
                    n4 = n11 << 1;
                    break;
                }
                case 1: {
                    sprite.img.getRGB(nArray, 0, n11, n18 + n13 - sprite.getX(), n15 + n17 - (n12 - sprite.getY()) - n10 - 1, n11, n10);
                    n20 = (n10 - 1) * n11;
                    n5 = 1;
                    n4 = -(n11 << 1);
                    break;
                }
                case 5: {
                    sprite.img.getRGB(nArray, 0, n10, n18 + n12 - sprite.getY(), n15 + n17 - (n13 - sprite.getX()) - n11, n10, n11);
                    n20 = (n11 - 1) * n10;
                    n5 = -n10;
                    n4 = n10 * n11 + 1;
                    break;
                }
                case 7: {
                    sprite.img.getRGB(nArray, 0, n10, n18 + n16 - (n12 - sprite.getY()) - n10, n15 + n17 - (n13 - sprite.getX()) - n11, n10, n11);
                    n20 = n10 * n11 - 1;
                    n5 = -n10;
                    n4 = n10 * n11 - 1;
                    break;
                }
                case 4: {
                    sprite.img.getRGB(nArray, 0, n10, n18 + n12 - sprite.getY(), n15 + n13 - sprite.getX(), n10, n11);
                    n20 = 0;
                    n5 = n10;
                    n4 = -(n10 * n11) + 1;
                    break;
                }
                case 6: {
                    sprite.img.getRGB(nArray, 0, n10, n18 + n16 - (n12 - sprite.getY()) - n10, n15 + n13 - sprite.getX(), n10, n11);
                    n20 = n10 - 1;
                    n5 = n10;
                    n4 = -(n10 * n11) - 1;
                    break;
                }
                default: {
                    return false;
                }
            }
            if (object != sprite) {
                Object object2;
                n7 = n20;
                n8 = n4;
                n9 = n5;
                if (object instanceof Sprite) {
                    sprite = (Sprite)object;
                    nArray = this.rgbDataAux;
                    n15 = sprite.sequence == null ? sprite.frame : sprite.sequence[sprite.frame];
                    n16 = sprite.getWidth();
                    n17 = sprite.getHeight();
                    n18 = n16 * (n15 % sprite.rows);
                    n15 = n17 * (n15 / sprite.rows);
                    continue;
                }
                if (object instanceof TiledLayer) {
                    bl2 = false;
                    object2 = (TiledLayer)object;
                    Image image = ((TiledLayer)object2).img;
                    n14 = 0;
                    n6 = 1;
                    n19 = 0;
                    n5 = ((TiledLayer)object2).getCellWidth();
                    n4 = ((TiledLayer)object2).getCellHeight();
                    int n21 = (n13 - n2) / n5;
                    int n22 = (n12 - n3) / n4;
                    int n23 = (n13 - n2 + n11 - 1) / n5;
                    int n24 = (n12 - n3 + n10 - 1) / n4;
                    for (int i2 = n22; i2 <= n24; ++i2) {
                        for (int i3 = n21; i3 <= n23; ++i3) {
                            int n25;
                            int n26;
                            int n27 = ((TiledLayer)object2).getCell(i3, i2);
                            if (n27 < 0) {
                                n27 = ((TiledLayer)object2).getAnimatedTile(n27);
                            }
                            int n28 = i3 == n21 ? (n13 - n2) % n5 : 0;
                            int n29 = i2 == n22 ? (n12 - n3) % n4 : 0;
                            int n30 = i3 == n23 ? (n13 + n11 - n2 - 1) % n5 : n5 - 1;
                            int n31 = i2 == n24 ? (n12 + n10 - n3 - 1) % n4 : n4 - 1;
                            int n32 = (i2 - n22) * n4 * n11 + (i3 - n21) * n5 - (i3 == n21 ? 0 : (n13 - n2) % n5) - (i2 == n22 ? 0 : (n12 - n3) % n4) * n11;
                            if (n27 == 0) {
                                n26 = n29;
                                while (n26 <= n31) {
                                    n25 = n28;
                                    while (n25 <= n30) {
                                        this.rgbDataAux[n32] = 0;
                                        ++n25;
                                        ++n32;
                                    }
                                    ++n26;
                                    n32 += n11 - (n30 - n28 + 1);
                                }
                                continue;
                            }
                            n26 = image.getWidth() / ((TiledLayer)object2).getCellWidth();
                            n25 = n5 * (--n27 % n26);
                            n27 = n27 / n26 * n4;
                            image.getRGB(this.rgbDataAux, n32, n11, n25 + n28, n27 + n29, n30 - n28 + 1, n31 - n29 + 1);
                        }
                    }
                    continue;
                }
                bl2 = false;
                object2 = (Image)object;
                ((Image)object2).getRGB(this.rgbDataAux, 0, n11, n13 - n2, n12 - n3, n11, n10);
                n14 = 0;
                n6 = 1;
                n19 = 0;
                continue;
            }
            bl2 = false;
            n14 = n20;
            n19 = n4;
            n6 = n5;
        }
        int n33 = 0;
        while (n33 < n10) {
            n5 = 0;
            while (n5 < n11) {
                n4 = this.rgbData[n7];
                int n34 = this.rgbDataAux[n14];
                if ((n4 & n34) >> 24 == -1) {
                    return true;
                }
                ++n5;
                n7 += n9;
                n14 += n6;
            }
            ++n33;
            n7 += n8;
            n14 += n19;
        }
        return false;
    }
}

