/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.ItemCommandListener;
import javax.microedition.lcdui.Screen;

public class Gauge
extends Item {
    static int HEIGHT = 15;
    int value;
    int maxValue;
    boolean interactive;
    public static final int INDEFINITE = -1;
    public static final int CONTINUOUS_IDLE = 0;
    public static final int INCREMENTAL_IDLE = 1;
    public static final int CONTINUOUS_RUNNING = 2;
    public static final int INCREMENTAL_UPDATING = 3;
    private int indefiniteFrame;
    private static final int IDEFINITE_FRAMES = 4;
    static int PAINT_TIMEOUT = 500;
    int prefWidth;
    int prefHeight;

    public Gauge(String string, boolean bl2, int n2, int n3) {
        super(string);
        this.interactive = bl2;
        this.setMaxValue(n2);
        this.setValue(n3);
    }

    public void setValue(int n2) {
        if (this.hasIndefiniteRange()) {
            if (n2 != 0 && n2 != 2 && n2 != 1 && n2 != 3) {
                throw new IllegalArgumentException();
            }
            if (n2 == 3 && this.value == 3) {
                this.updateIndefiniteFrame();
                return;
            }
            this.value = n2;
            this.repaint();
            return;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 > this.maxValue) {
            n2 = this.maxValue;
        }
        this.value = n2;
        this.repaint();
    }

    public int getValue() {
        return this.value;
    }

    public void setMaxValue(int n2) {
        if (n2 > 0) {
            this.maxValue = n2;
            Gauge gauge = this;
            gauge.setValue(gauge.getValue());
            return;
        }
        if (this.isInteractive()) {
            throw new IllegalArgumentException();
        }
        if (n2 != -1) {
            throw new IllegalArgumentException();
        }
        if (this.maxValue == -1) {
            return;
        }
        this.maxValue = -1;
        this.value = 1;
        this.repaint();
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public boolean hasIndefiniteRange() {
        return !this.isInteractive() && this.getMaxValue() == -1;
    }

    public void updateIndefiniteFrame() {
        if (this.hasIndefiniteRange() && (this.getValue() == 2 || this.getValue() == 3)) {
            this.indefiniteFrame = this.indefiniteFrame + 1 < 4 ? ++this.indefiniteFrame : 0;
            this.repaint();
        }
    }

    int getHeight() {
        return super.getHeight() + HEIGHT;
    }

    boolean isFocusable() {
        return this.interactive;
    }

    void keyPressed(int n2) {
        if (Display.getGameAction(n2) == 2 && this.value > 0) {
            --this.value;
            this.repaint();
            return;
        }
        if (Display.getGameAction(n2) == 5 && this.value < this.maxValue) {
            ++this.value;
            this.repaint();
        }
    }

    int paint(Graphics graphics) {
        super.paintContent(graphics);
        graphics.translate(0, super.getHeight());
        if (this.hasFocus()) {
            graphics.drawRect(2, 2, this.owner.getWidth() - 5, HEIGHT - 5);
        }
        if (this.hasIndefiniteRange()) {
            if (this.getValue() == 0 || this.getValue() == 1) {
                int n2 = this.owner.getWidth() - 9;
                graphics.drawRect(4, 4, n2, HEIGHT - 9);
            } else {
                int n3 = (this.owner.getWidth() - 8 << 1) / 4;
                int n4 = (n3 >>> 1) * this.indefiniteFrame;
                int n5 = 0;
                if (n4 + n3 > this.owner.getWidth() - 8) {
                    n5 = n4 + n3 - (this.owner.getWidth() - 8);
                    n3 -= n5;
                }
                graphics.fillRect(n4 + 4, 4, n3, HEIGHT - 8);
                if (n5 != 0) {
                    graphics.fillRect(4, 4, n5, HEIGHT - 8);
                }
            }
        } else {
            int n6 = (this.owner.getWidth() - 8) * this.value / this.maxValue;
            graphics.fillRect(4, 4, n6, HEIGHT - 8);
        }
        graphics.translate(0, -super.getHeight());
        return this.getHeight();
    }

    int traverse(int n2, int n3, int n4, boolean bl2) {
        if (n2 == 1) {
            if (n3 > 0) {
                return -n3;
            }
            return Integer.MAX_VALUE;
        }
        if (n2 == 6) {
            if (this.getHeight() > n4) {
                return this.getHeight() - n4;
            }
            return Integer.MAX_VALUE;
        }
        return 0;
    }

    public void setPreferredSize(int n2, int n3) {
        Screen screen = this.getOwner();
        if (screen != null && screen instanceof Alert) {
            return;
        }
        super.setPreferredSize(n2, n3);
    }

    public void setLayout(int n2) {
        if (this.owner != null && this.owner instanceof Alert) {
            return;
        }
        super.setLayout(n2);
    }

    public void setLabel(String string) {
        if (this.owner != null && this.owner instanceof Alert) {
            return;
        }
        super.setLabel(string);
    }

    public void addCommand(Command command) {
        if (this.owner != null && this.owner instanceof Alert) {
            return;
        }
        super.addCommand(command);
    }

    public void setDefaultCommand(Command command) {
        if (this.owner != null && this.owner instanceof Alert) {
            return;
        }
        super.setDefaultCommand(command);
    }

    public void setItemCommandListener(ItemCommandListener itemCommandListener) {
        if (this.owner != null && this.owner instanceof Alert) {
            return;
        }
        super.setItemCommandListener(itemCommandListener);
    }
}

