/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Ticker;
import org.microemu.device.Device;
import org.microemu.device.DeviceFactory;
import org.microemu.device.ui.CommandUI;
import org.microemu.device.ui.DisplayableUI;

public abstract class Displayable {
    Device device = DeviceFactory.getDevice();
    public Display currentDisplay = null;
    public int width = -1;
    public int height = -1;
    public boolean fullScreenMode = false;
    Ticker ticker;
    int viewPortY;
    int viewPortHeight;
    public DisplayableUI ui;
    private String title;
    private CommandListener listener = null;
    public static long timeClick = 0L;
    public static boolean enableAutoSleep = true;

    Displayable(String string) {
        this.title = string;
        timeClick = System.currentTimeMillis();
    }

    void setUI(DisplayableUI displayableUI) {
        this.ui = displayableUI;
    }

    public void addCommand(Command command) {
        this.ui.addCommandUI(command.ui);
    }

    public void removeCommand(Command command) {
        this.ui.removeCommandUI(command.ui);
    }

    public int getWidth() {
        if (this.width == -1) {
            this.width = this.fullScreenMode ? this.device.getDeviceDisplay().getFullWidth() : this.device.getDeviceDisplay().getWidth();
        }
        return this.width;
    }

    public int getHeight() {
        if (this.height == -1) {
            this.height = this.fullScreenMode ? this.device.getDeviceDisplay().getFullHeight() : this.device.getDeviceDisplay().getHeight();
        }
        return this.height;
    }

    public boolean isShown() {
        if (this.currentDisplay == null) {
            return false;
        }
        return this.currentDisplay.isShown(this);
    }

    public Ticker getTicker() {
        return this.ticker;
    }

    public void setTicker(Ticker ticker) {
        this.ticker = ticker;
        this.repaint();
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
        this.ui.invalidate();
    }

    public void setCommandListener(CommandListener commandListener) {
        this.listener = commandListener;
        this.ui.setCommandListener(commandListener);
    }

    public CommandListener getCommandListener() {
        return this.listener;
    }

    public Vector getCommands() {
        Vector<Command> vector = new Vector<Command>();
        Vector vector2 = this.ui.getCommandsUI();
        for (int i2 = 0; i2 < vector2.size(); ++i2) {
            vector.addElement(((CommandUI)vector2.elementAt(i2)).getCommand());
        }
        return vector;
    }

    public void hideNotify() {
    }

    public final void hideNotify(Display display) {
        this.ui.hideNotify();
        this.hideNotify();
    }

    public void keyPressed(int n2) {
    }

    public void keyRepeated(int n2) {
    }

    public void keyReleased(int n2) {
    }

    public void pointerPressed(int n2, int n3) {
    }

    public void pointerReleased(int n2, int n3) {
    }

    public void pointerDragged(int n2, int n3) {
    }

    public abstract void paint(Graphics var1);

    public void repaint() {
        if (this.currentDisplay != null) {
            if (enableAutoSleep && !(this.currentDisplay.getCurrent() instanceof a) && System.currentTimeMillis() - timeClick >= 300000L) {
                new a(this).a();
                return;
            }
            this.repaint(0, 0, this.getWidth(), this.getHeight());
        }
    }

    void repaint(int n2, int n3, int n4, int n5) {
        if (this.currentDisplay != null) {
            this.currentDisplay.repaint(this, n2, n3, n4, n5);
        }
    }

    protected void sizeChanged(int n2, int n3) {
    }

    public final void sizeChanged(Display display) {
        this.width = -1;
        this.height = -1;
        Displayable displayable = this;
        displayable.sizeChanged(displayable.getWidth(), this.getHeight());
    }

    void showNotify() {
    }

    public final void showNotify(Display display) {
        this.currentDisplay = display;
        this.viewPortY = 0;
        w w2 = new w(this.getTitle());
        this.viewPortHeight = this.getHeight() - w2.b() - 1;
        if (this.ticker != null) {
            this.viewPortHeight -= this.ticker.getHeight();
        }
        int n2 = this.fullScreenMode ? this.device.getDeviceDisplay().getFullWidth() : this.device.getDeviceDisplay().getWidth();
        int n3 = this.fullScreenMode ? this.device.getDeviceDisplay().getFullHeight() : this.device.getDeviceDisplay().getHeight();
        if (this.width != n2 || this.height != n3) {
            this.sizeChanged(display);
        }
        this.showNotify();
        this.ui.showNotify();
    }
}

